ArenaFramesDB = {}
if not ArenaFramesDB.scale then
	ArenaFramesDB.scale=1.1
end

local core = CreateFrame("Frame", "ArenaFrameMover", UIParent) 
core:SetPoint("RIGHT", UIParent, 0, 0) 
core:CreateTitleRegion():SetAllPoints()
core:EnableMouse(false)
core:SetMovable(true)
core:SetUserPlaced(true)
core:SetSize(120, 20)
core:SetBackdrop({bgFile = "Interface/Tooltips/UI-Tooltip-Background", 
                                            edgeFile = "Interface/Tooltips/UI-Tooltip-Border", 
                                            tile = true, tileSize = 16, edgeSize = 16, 
                                            insets = { left = 4, right = 4, top = 4, bottom = 4 }});
core:SetBackdropColor(0,0,0,0);
core:SetBackdropBorderColor(0,0,0,0);

function core:ADDON_LOADED(addonName)  
	if addonName ~= "Blizzard_ArenaUI" then return end  
		ArenaEnemyFrame1:ClearAllPoints()  
		ArenaEnemyFrame1:SetPoint("TOP", core, "BOTTOM", 0, 0)  
		ArenaEnemyFrames:SetScale(ArenaFramesDB.scale)  
		local arenaFrame, trinket  
	for i = 1, MAX_ARENA_ENEMIES do  
		arenaFrame = "ArenaEnemyFrame"..i  
		trinket = CreateFrame("Cooldown", arenaFrame.."Trinket", ArenaEnemyFrames)  
		trinket:SetPoint("TOPRIGHT", arenaFrame, 30, -6)  
		trinket:SetSize(30, 30)  
		trinket.icon = trinket:CreateTexture(nil, "BACKGROUND")  
		trinket.icon:SetAllPoints()  
		trinket.icon:SetTexture("Interface\\Icons\\inv_jewelry_trinketpvp_01")  
		trinket:Hide()  
		core["arena"..i] = trinket  
	end  
self:UnregisterEvent("ADDON_LOADED")  
end  

function core:UNIT_SPELLCAST_SUCCEEDED(unitID, spell, rank, lineID, spellID)  
if not core[unitID] then return end  
	if  spell == GetSpellInfo(59752) or spell == GetSpellInfo(42292) then  
		CooldownFrame_SetTimer(core[unitID], GetTime(), 120, 1)  
		SendChatMessage(GetUnitName(unitID.." ", true), "PARTY")  
	elseif spell == GetSpellInfo(7744) then  
		CooldownFrame_SetTimer(core[unitID], GetTime(), 45, 1)  
		SendChatMessage(GetUnitName(unitID, true).."  ", "PARTY")  
	end  
end  

function core:PLAYER_ENTERING_WORLD()  
local _, instanceType = IsInInstance()  
	if instanceType == "arena" then  
		self:RegisterEvent("UNIT_SPELLCAST_SUCCEEDED")  
	elseif self:IsEventRegistered("UNIT_SPELLCAST_SUCCEEDED") then  
		self:UnregisterEvent("UNIT_SPELLCAST_SUCCEEDED")  
		for _, trinket in pairs(core) do  
			trinket:SetCooldown(0, 0)  
			trinket:Hide()  
		end  
	end  
end  

SLASH_ACFG1 = "/acfg"  
SlashCmdList["ACFG"] = function(msg, editBox)  
	if not IsAddOnLoaded("Blizzard_ArenaUI") then LoadAddOn("Blizzard_ArenaUI") end 
	core:SetBackdropColor(0,0,0,1);
	core:SetBackdropColor(1,1,1,1);	
ArenaEnemyFrames:Show()  
local arenaFrame 
core:EnableMouse(true)
	for i = 1, 3 do  
		arenaFrame = _G["ArenaEnemyFrame"..i] 
		arenaFrame.classPortrait:SetTexture("Interface\\TargetingFrame\\UI-Classes-Circles")  
		arenaFrame.classPortrait:SetTexCoord(unpack(CLASS_ICON_TCOORDS["WARRIOR"]))  
		arenaFrame.name:SetText("test")  
		arenaFrame:Show()  
		CooldownFrame_SetTimer(core["arena"..i], GetTime(), 120, 1)  
	end 

core.scale = CreateFrame("Slider", "MySliderGlobalName", core, "OptionsSliderTemplate")
core.scale:SetSize(120, 15)
core.scale:SetPoint("BOTTOM",core, "TOP",0,4)
core.scale:SetMinMaxValues(1,2)
core.scale:SetValueStep(.1)
core.scale:SetValue(ArenaFramesDB.scale)
core.scale:SetScript("OnValueChanged", function(self)
 ArenaFramesDB.scale=self:GetValue() 
 ArenaEnemyFrames:SetScale(ArenaFramesDB.scale)
	end)	
end  

core:SetScript("OnEvent", function(self, event, ...) return self[event](self, ...) end)  
core:RegisterEvent("ADDON_LOADED")  
core:RegisterEvent("PLAYER_ENTERING_WORLD")  
hooksecurefunc("PlayerFrame_UpdateStatus", function()   
	if IsResting("player") then   
		PlayerStatusTexture:Hide() 
	end 
end)  