-------------
-- RUSSIAN --
-------------
-- Autor: gth
-- Last update: 02.05.2016 - 01:17

if (GetLocale() == "ruRU") then
	-- Container to all this... to reduce size of global namespace :D
KARMAAVENK_LANG_LOC.PREF = "RU";
	KARMAAVENK_LANG_LOC.RU = {};
	local	K = KARMAAVENK_LANG_LOC.RU;

----------------------------------------------------------------------------------------------------
-- most likely stays unmodified for any language, still there might be a case for asian languages --
----------------------------------------------------------------------------------------------------

KARMA_WINEL_FRAG_COLON = ":";
KARMA_WINEL_FRAG_COLONSPACE = ": ";
KARMA_WINEL_FRAG_SPACE = " ";
KARMA_WINEL_FRAG_NEWLINE = "\n";
KARMA_WINEL_FRAG_PLUS = "+";
KARMA_WINEL_FRAG_BRACKET_LEFT = "(";
KARMA_WINEL_FRAG_BRACKET_RIGHT = ")";
KARMA_WINEL_FRAG_TRIDOTS = "...";

KARMA_CMDLINE_HELP_COLOR1 = "cFF7F8FAF";
KARMA_CMDLINE_HELP_COLOR2 = "cFF8FAFFF";

KARMA_ITSELF = "Karma";
KARMA_ITSELF_COLONSPACE = KARMA_ITSELF .. KARMA_WINEL_FRAG_COLONSPACE;
KARMA_CMDSELF = "/karma";

KARMA_TITLE = KARMA_ITSELF;

-----------------------------------------------------
-- start of the stuff that's likely to be modified --
-----------------------------------------------------

-- this one must stay global to be accessible
KARMA_MYADDONS_HELP = {
	"Usage: '" .. KARMA_CMDSELF .. "'\nThis will open the main window. You can also bind a key to this."
};

K.INITIAL_MESSAGE = " загружено... команда для справки: " .. KARMA_CMDSELF .. " ";

K.CMDUNKNOWN_PRE = "Команда >";
K.CMDUNKNOWN_POST = "< не найдена.";

KARMA_CMDLINE_HELP_SHORT = {
	KARMA_ITSELF .. " *** Справка по командам|r",
	"" .. KARMA_CMDSELF .. " <команда> [<аргумент>] ...'|" ..KARMA_CMDLINE_HELP_COLOR2 .. "– общий формат для команд аддона (также можно использовать сокращенный вид /kar)|r",
	"Общие команды:|r",
	"   help [all|quick|alts|lfm|options|db|exchange] |" ..KARMA_CMDLINE_HELP_COLOR2 .. "- справка по командам: [all] - по всем командам; [quick] - только список команд; [alts] - для твинков; [lfm] - для окна LFM; [options] - по настройкам; [db] - для внутренней базы данных; [exchange] - для работы с внешними базами данных|r",
	"   resetgui |" .. KARMA_CMDLINE_HELP_COLOR2 .. "- сбрасывает расположение значка у мини-карты, главного окна и окна LFM|r",
	"   window (или win) |" ..KARMA_CMDLINE_HELP_COLOR2 .. "– открывает главное окно|r",
	"   options (или opt) |" ..KARMA_CMDLINE_HELP_COLOR2 .. "- открывает окно настроек|r",
	"   showonline |" .. KARMA_CMDLINE_HELP_COLOR2 .. "– открывает окно LFM|r",
	"   addmember <имя игрока> (или add) |" ..KARMA_CMDLINE_HELP_COLOR2 .. "– добавляет в базу <игрока>|r",
	"   ignore <имя игрока> (или ign) |" ..KARMA_CMDLINE_HELP_COLOR2 .. "– добавляет в базу и игнорирует <Игрока> снизив его рейтинг до 1|r",
	"   update <имя игрока> |" ..KARMA_CMDLINE_HELP_COLOR2 .. "– пытается обновить данные <игрока> или цель, если имя не указано|r",
	"   remove <имя игрока> (или rem) |" ..KARMA_CMDLINE_HELP_COLOR2 .. "– удаляет из базы <игрока>|r",
	"   give <имя игрока> |" .. KARMA_CMDLINE_HELP_COLOR2 .. "– поднимает рейтинг <игрока> на 3 единицы|r",
	"   take <имя игрока> |" .. KARMA_CMDLINE_HELP_COLOR2 .. "– снижает рейтинг <игрока> на 3 единицы|r",
};

KARMA_CMDLINE_HELP_LFM = {
	"Команды для окна LFM:|r",
	"   checkchannel <канал> |" .. KARMA_CMDLINE_HELP_COLOR2 .. "– сравнение игроков выбранного <канала> с записями в базе|r",
	"   checkclass <класс> <уровень> |" .. KARMA_CMDLINE_HELP_COLOR2 .. "– сравнение выбранного <класса> игроков онлайн с записями в базе; <уровень> не обязателен|r",
	"   checkallclasses <уровень> |" .. KARMA_CMDLINE_HELP_COLOR2 .. "– сравнение по классам игроков онлайн с записями в базе; <уровень> не обязателен|r",
	"   checkguild <гильдия> |" .. KARMA_CMDLINE_HELP_COLOR2 .. "– сравнение по гильдиям игроков онлайн с записями в базе; можно вводить часть названия гильдии|r",
	};

KARMA_CMDLINE_HELP_OPTIONS = {
	"Команды настроек аналогичных в окне настроек:|r",
	"   sortby <[name||played||exp||time]> |" ..KARMA_CMDLINE_HELP_COLOR2 .. "– сортировать список по <...>|r",
	"   colorby <[played||exp||time]> |" ..KARMA_CMDLINE_HELP_COLOR2 .. "– цвет имен в списке по <...>|r",
	"   karmatips |" ..KARMA_CMDLINE_HELP_COLOR2 .. "– показать/скрыть рейтинг в подсказках|r",
	"   notetips |" ..KARMA_CMDLINE_HELP_COLOR2 .. "– показать/скрыть заметки в подсказках|r",
	"   qcachewarn |" ..KARMA_CMDLINE_HELP_COLOR2 .. "– вкл/выкл предупреждения при неполном отображении журнала заданий|r",
	"   autoignore <[on||off]> |" ..KARMA_CMDLINE_HELP_COLOR2 .. "– вкл/выкл автоигнор|r",
	"   autochecktalents |" ..KARMA_CMDLINE_HELP_COLOR2 .. "– вкл/выкл автосканирование талантов в группах|r",
	};

KARMA_CMDLINE_HELP_ALTS = {
	"Команды для твинков:|r",
	"   altadd <игрок1> <игрок2> |" ..KARMA_CMDLINE_HELP_COLOR2 .. "– <игрок1> и <игрок2> добавляются в общую группу твинков|r",
	"   altrem <игрок> |" ..KARMA_CMDLINE_HELP_COLOR2 .. "– удаляет <игрока> из группы твинков|r",
	"   altlist <игрок> |" ..KARMA_CMDLINE_HELP_COLOR2 .. "– отображает список твинков <игрока>|r",
	};

KARMA_CMDLINE_HELP_DB = {
	"Команды для внутренней базы данных:|r",
	"   clean |" ..KARMA_CMDLINE_HELP_COLOR2 .. "– удаляет записи, соответствующие установленным критериям|r",
	"   cleanpvp |" ..KARMA_CMDLINE_HELP_COLOR2 .. "– удаляет записи с БГ и кросс-серверов|r",
	"   veryclean |" ..KARMA_CMDLINE_HELP_COLOR2 .. "– удаляет записи с кросс-серверов|r",
	"   questcache <[-1||0||a quest id]> |" ..KARMA_CMDLINE_HELP_COLOR2 .. "– показывает журнал ваших заданий|r",
	"   skillmodel <[complex||simple]> |" ..KARMA_CMDLINE_HELP_COLOR2 .. "– переключает список навыков: [simple] - краткий (по умолчанию); [complex] - расширенный|r",
	};

KARMA_CMDLINE_HELP_EXCHANGE = {
	"Команды для внешних баз данных доверенных другими игроками:|r",
	"   |cFFFF4010Не используйте эти команды от нечего делать, так как это может вызвать обрыв связи у вас или другого игрока!|r",
	"   |" .. KARMA_CMDLINE_HELP_COLOR2 .. "Для работы с внешними базами данных включите вспомогательный аддон KarmaTrans, чтобы получить (и сохранить) все данные.|r",
	"   exchangeallow [<игрок>] |" ..KARMA_CMDLINE_HELP_COLOR2 .. "– разрешает <игроку> загружать интересующие части вашей базы данных: информацию, которая может быть собрана с помощью команды /who; GUID, рейтинги и публичные заметки|r",
	"   exchangerequest <игрок> [<start>] |" ..KARMA_CMDLINE_HELP_COLOR2 .. "– спрашивает <Имя> игрока, чтобы инициировать передачу данных, при необходимости можно указать чтобы выполнение начиналось с ввода <start>; другой игрок должен заранее разрешить обмен!|r",
	"   exchangetrust <игрок> <уровень доверия> |" ..KARMA_CMDLINE_HELP_COLOR2 .. "– для <игрока> устанавливает <уровень доверия> (0.01 .. 1.0), определяет насколько сильно вы доверяете мнению этого игрока относительно значений в вашей базе|r",
	"   exchangeupdate |" ..KARMA_CMDLINE_HELP_COLOR2 .. "– обновляет базу данных всей импортированной информацией|r",
	"   |" .. KARMA_CMDLINE_HELP_COLOR2 .. "Обмен данными от А к Б происходит в следующем порядке: А заранее разрешает обмен для Б; Б делает запрос на получение данных от А и ждет; Б устанавливает уровень доверия к А; Б получает данные|r",
	"Команды требующие работу над файлами вне игры:|r",
	"   export <[*||<name>]> |" ..KARMA_CMDLINE_HELP_COLOR2 .. "– экспорт <Игрока> или всего массива данных текущего сервера/фракции|r",
	"   import |" ..KARMA_CMDLINE_HELP_COLOR2 .. "– импорт доступных массивов данных|r",
	"   transport |" ..KARMA_CMDLINE_HELP_COLOR2 .. "– очистка массивов данных экспорта и импорта|r",
	"   Некоторые параметры чувствительны к регистру, например имена игроков|r"
};

-- NOT "SHORT"
KARMA_CMDLINE_HELPMETA_LONG = {
	"ALTS"
};

-- NOT "SHORT"
KARMA_CMDLINE_HELPMETA_FULL = {
	"ALTS", "LFM", "OPTIONS", "DB", "EXCHANGE"
};

-- legacy support for translations
KARMA_CMDLINE_HELPMETA_LEGACY = {
	"LONG"
};


KARMA_UNKNOWN = "Unknown";
KARMA_UNKNOWN_ENT = "Unknown Entity";

KARMA_DATEFORMAT = "%d/%m/%Y";       -- изменен формат даты

KARMA_WINEL_TITLE = KARMA_ITSELF;

KARMA_WINEL_OK = "Ok";
KARMA_WINEL_APPLY = "Применить";
KARMA_WINEL_CANCEL = "Отмена";

KARMA_WINEL_FILTER = "Фильтр";

KARMA_CHATMSG_VARIOUS_REGIONS = "Various Regions";

KARMA_WINEL_INCREASE = "Рейтинг +3";
KARMA_WINEL_DECREASE = "Рейтинг -3";

KARMA_WINEL_NOTESPUBLIC = "Публичные заметки";
KARMA_WINEL_NOTESPUBLICFRAMETITLE = KARMA_WINEL_NOTESPUBLIC .. KARMA_WINEL_FRAG_COLONSPACE .. "(макс. 40 символов!)";
KARMA_WINEL_NOTESPUBLICQUERYGUILD = "Запросить...";
KARMA_WINEL_NOTESPUBLICRESULTS = "<!>";
KARMA_WINEL_NOTESSCROLLFRAMETITLE = "Личные заметки:";
KARMA_WINEL_PARTYLISTTITLE = "Ваша группа:";
KARMA_WINEL_MEMBERLISTTITLE = "Полный список";
KARMA_WINEL_CHOSENPLAYERTITLE = "Имя:";
KARMA_WINEL_CHOSENPLAYERXPTITLE = "Опыт:";
KARMA_WINEL_CHOSENPLAYERXPACCRUEDTITLE = "Накоплено:";
KARMA_WINEL_CHOSENPLAYERXPPERCENTAGETITLE = "Процент:";
KARMA_WINEL_CHOSENPLAYERTIMETITLE = "Игровое время:";
KARMA_WINEL_CHOSENPLAYERTIMEACCRUEDTITLE = "Накоплено:";
KARMA_WINEL_CHOSENPLAYERTIMEPERCENTAGETITLE = "Процент:";
KARMA_WINEL_KARMAINDICATORTITLE = " Рейтинг:";
KARMA_WINEL_KARMAREGIONLIST = "Подземелья:";
KARMA_WINEL_KARMAZONELIST = "Зоны:";
KARMA_WINEL_KARMAQUESTLIST = "Квесты:";
KARMA_WINEL_KARMAACHIEVEMENTLIST = "Достижения:";
KARMA_WINEL_MAINALTLIST = "Твинки:";

KARMA_WINEL_TALENTSBUTTON = "Талы 1";
KARMA_WINEL_TALENTS2BUTTON = "Талы 2";
KARMA_WINEL_TALENTWND_TALENT_TITLE = "Роль";
KARMA_WINEL_FILTERBUTTON = KARMA_WINEL_FILTER .. KARMA_WINEL_FRAG_COLONSPACE;
KARMA_WINEL_OPTIONSBUTTON = "Настройки";
KARMA_WINEL_INVITEBUTTON = "Пригласить";
KARMA_WINEL_UPDATEBUTTON = "Обновить";
KARMA_WINEL_NEWFORCEBUTTON = "Forcenew (conflict)";
KARMA_WINEL_UPDATEFORCEBUTTON = "Forceupdate (conflict)";
KARMA_WINEL_REMOVEBUTTON = "Удалить";
KARMA_WINEL_CLOSEBUTTON = "Закрыть";
KARMA_WINEL_POSTTOCHATBUTTON = "Отправить в чат";

KARMA_WINEL_REMOVE_QUESTION_TEXT_PRE = "ВЫ уверены что хотите удалить >";
KARMA_WINEL_REMOVE_QUESTION_TEXT_POST = "< из списка";
KARMA_WINEL_REMOVE_QUESTION_BTN_EXECUTE = "УДАЛИТЬ!";
KARMA_WINEL_REMOVE_QUESTION_BTN_CANCEL = "Отменить";

--
KARMA_WINEL_FILTER_TITLE = "Параметры фильтра:";
KARMA_WINEL_FILTER_NAME = "Имя: ";
KARMA_WINEL_FILTER_NAMESTARTS = "Имя начинается с:";
KARMA_WINEL_FILTER_NAMECONTAINS = "и содержит:";
KARMA_WINEL_FILTER_CLASS = "Класс: ";
KARMA_WINEL_FILTER_LEVELFROM = "Уровень от ";
KARMA_WINEL_FILTER_LEVELTO = " до ";
KARMA_WINEL_FILTER_KARMAFROM = "Рейтинг от ";
KARMA_WINEL_FILTER_KARMATO = " до ";
KARMA_WINEL_FILTER_JOINEDAFTER = "Добавлен после ";
KARMA_WINEL_FILTER_JOINEDBEFORE = " и перед ";
KARMA_WINEL_FILTER_JOINED_TITLE = "Добавлен после/перед";
KARMA_WINEL_FILTER_NOTE = "Заметка содержит: ";
KARMA_WINEL_FILTER_NOTEPRIVATE = "Приватная заметка содержит: ";
KARMA_WINEL_FILTER_NOTEPUBLIC = "Публичная заметка содержит: ";
KARMA_WINEL_FILTER_REGIONVISITEDWITH = "Посещенные подземелья: ";

--
KARMA_WINEL_PLAYER_TITLE = "Игрок: ";
KARMA_WINEL_HPS = "Хил";
KARMA_WINEL_DPS = "ДД";
KARMA_WINEL_TANK = "Танк";
KARMA_WINEL_MELEE = "Ближний бой";
KARMA_WINEL_RANGED = "Дальний бой";

--
KARMA_WINEL_CATEGORYAREATITLE = "Категории:";
KARMA_WINEL_OPTCAT1 = "Сортировка/Цвет";
KARMA_WINEL_OPTCAT2 = "Подсказка";
KARMA_WINEL_OPTCAT3 = "Автоигнор/предупрежд.";
KARMA_WINEL_OPTCAT4 = "Окна чата";
KARMA_WINEL_OPTCAT5 = "Авторейтинг";
KARMA_WINEL_OPTCAT80 = "Обмен данными";
KARMA_WINEL_OPTCAT90 = "Другое";
KARMA_WINEL_OPTCAT95 = "Стандартные функции";
KARMA_WINEL_OPTCAT99 = "Очистка базы данных";

--
KARMA_WINEL_SORTINGAREATITLE = "Сортировка и раскраска";
KARMA_WINEL_SORTBYDROPDOWNTITLE = "Сортировать по:";
KARMA_WINEL_COLORBYDROPDOWNTITLE = "Раскрашивать по:";

KARMA_WINEL_DROPDOWNBYKARMA = "Рейтингу";
KARMA_WINEL_DROPDOWNBYXP = "Опыт с текущим персонажем";
KARMA_WINEL_DROPDOWNBYXPLVL = "Опыт с текущим персонажем (lvl)";
KARMA_WINEL_DROPDOWNBYTIME = "Время с текущим персонажем";
KARMA_WINEL_DROPDOWNBYXPALL = "Опыт со всеми вашими персонажами";
KARMA_WINEL_DROPDOWNBYXPLVLALL = "Опыт со всеми вашими персонажами (lvl)";
KARMA_WINEL_DROPDOWNBYTIMEALL = "Время со всеми вашими персонажами";
KARMA_WINEL_DROPDOWNBYNAME = "Имя";
KARMA_WINEL_DROPDOWNBYCLASS = "Класс";
KARMA_WINEL_DROPDOWNBYJOINED = "Joined most recently";
KARMA_WINEL_DROPDOWNBYJOINEDTHIS = "Joined most recently w/ current char";
KARMA_WINEL_DROPDOWNBYTALENT = "Роль";
KARMA_WINEL_DROPDOWNBYGUILDTOP = "Гильдия (без гильдии вверх)";
KARMA_WINEL_DROPDOWNBYGUILDBOTTOM = "Гильдия (без гильдии вниз)";

KARMA_WINEL_COLORSPACE_AREATITLE = "Тонкая настройка цветов";
KARMA_WINEL_COLORSPACE_ENABLE_CHECKBOX_TITLE = "Включить настройки цветов";
KARMA_WINEL_COLORSPACE_KARMA_TITLE = "Рейтинг: ";
KARMA_WINEL_COLORSPACE_TIME_TITLE = "Время:";
KARMA_WINEL_COLORSPACE_XP_TITLE = "Опыт:";

--
KARMA_WINEL_CHATWINDOWSAREATITLE = "Используемые окна чата";
KARMA_WINEL_CHATDEFAULTTITLE = "Окно по умолчанию:";
KARMA_WINEL_CHATSECONDARYTITLE = "Дополнительное окно:";
KARMA_WINEL_CHATDEBUGTITLE = "Окно отладки:";
KARMA_WINEL_CHATDROPDOWNRESET = "Сбросить";

--
KARMA_WINEL_AUTOIGNOREAREATITLE = "Настройки автоигнора/автопредупреждений:";
KARMA_WINEL_AUTOIGNOREENABLEDCHECKBOXTITLE = "Включить автоигнор";
KARMA_WINEL_IGNOREINVITESCHECKBOXTITLE = "Автоигнор приглашений/обмена/дуэли";
KARMA_WINEL_AUTOIGNORETHRESHOLD = "Порог рейтинга для автоигнора";
KARMA_WINEL_WARNLOWKARMA_TITLE = "Предупреждать игроков с низким рейтингом";
KARMA_WINEL_WARNLOWKARMA_THRESHOLD = "Порог рейтинга для предупреждений";

--
KARMA_WINEL_MARKUPAREATITLE = "Пометки (расцветка имен в чатах и рейтинг):";
KARMA_WINEL_MARKUPENABLEDCHECKBOXTITLE = "Включить пометки";
KARMA_WINEL_MARKUPVERSIONCHECKBOXTITLE = "новая версия";
KARMA_WINEL_MARKUPWHISPERSCHECKBOXTITLE = "Пометка в привате";
KARMA_WINEL_MARKUPCHANNELSCHECKBOXTITLE = "Пометка в каналах";
KARMA_WINEL_MARKUPYELLSAYEMOTECHECKBOXTITLE = "в разговоре и эмоциях";
KARMA_WINEL_MARKUPGUILDCHECKBOXTITLE = "Пометка в чате гильдии";
KARMA_WINEL_MARKUPRAIDCHECKBOXTITLE = "Пометка в чате группы/рейда";
KARMA_WINEL_MARKUPBGCHECKBOXTITLE = "Пометка в чате БГ";

--
KARMA_WINEL_OPTIONSDBCLEANAREATITLE = "Настройки очистки базы данных:";

KARMA_WINEL_AUTOCLEANCHECKBOXTITLE = "Автоочистка (Только если вы уверены!)";
KARMA_WINEL_AUTOCLEANCHECKBOXTOOLTIP = {
		"Автоочистка",
		"Эта функция будет выполнять очистку при каждом входе в игру.",
		"Если включена эта опция, то желательно чаще выполнять",
		"резервное копирование базы данных."
	};
KARMA_WINEL_AUTOCLEANCHECKBOXTOOLTIPEXTRA = "(Вы регулярно делаете резервное копирование?)";

KARMA_WINEL_AUTOCLEANPVPCHECKBOXTITLE = "Автоочистка PvP записей после каждого БГ";

KARMA_WINEL_DBCLEANSECTIONTITLE = "Условия сохранения/удаления записей:";

KARMA_WINEL_DBCLEANKEEPIFNOTETITLE = "Оставлять если есть заметки";
KARMA_WINEL_DBCLEANKEEPIFNOTETOOLTIP = {
		"Оставлять если есть заметки",
		"Если эта опция включена, записи с заметками не удаляются.",
		"Эта опция обязательна, если вы хотите сохранить записи с кросс-серверов,",
		"у которых есть заметки!"
	};

KARMA_WINEL_DBCLEANREMOVEPVPJOINSTITLE = "Удалять если добавлены в PvP зонах";
KARMA_WINEL_DBCLEANREMOVEPVPJOINSTOOLTIP = {
		"Удалять если добавлены в PvP зонах",
		"Если эта опция включена, то записи добавленные в PvP зонах без заметок будут удаляться.",
		"Если опция ниже НЕ включена, то все записи с PvP зон будут удаляться,",
		"даже с заметками!"
	};

KARMA_WINEL_DBCLEANREMOVEXSERVERTITLE = "Удалять если с кросс-сервера (-> Name (*) <-)";
KARMA_WINEL_DBCLEANREMOVEXSERVERTOOLTIP = {
		"Удалять если с кросс-сервера",
		"Если эта опция включена, то записи с кросс-серверов без заметок будут удаляться.",
		"Если опция ниже НЕ включена, то все записи с кросс-серверов будут удаляться,",
		"даже с заметками!"
	};

KARMA_WINEL_DBCLEANKEEPIFKARMATITLE = "Оставлять если рейтинг не равен 50";
KARMA_WINEL_DBCLEANKEEPIFKARMATOOLTIP = {
		"Оставлять если рейтинг изменен",
		"Если эта опция включена, то все записи с рейтингом отличным от 50 будут сохраняться.",
		"(Эта проверка выполняется после проверок на заметки и кросс-сервер.)"
	};

KARMA_WINEL_DBCLEANKEEPIFQUESTNUMTITLE = "или больше квестов - сохранять";
KARMA_WINEL_DBCLEANKEEPIFQUESTNUMTOOLTIP = {
		"Оставляеть если есть совместно выполненые задания",
		"Оставляет записи если количество заданий (частично или полностью) не меньше указанного.",
		"(Эта проверка выполняется после проверок на заметки и кросс-сервер.)"
	};

KARMA_WINEL_DBCLEANKEEPIFREGIONNUMTITLE = "или больше подземелий - сохранять";
KARMA_WINEL_DBCLEANKEEPIFREGIONNUMTOOLTIP = {
		"Оставляеть если есть совместно пройденые подземелья.",
		"Оставляет записи если количество совместно пройденых подземелий не меньше указанных.",
		"Если игнорировать PVP области/зоны, то они небудут защитоваться",
		"(Эта проверка выполняется после проверок на заметки и кросс-сервер.)"
	};

KARMA_WINEL_DBCLEANKEEPIFZONENUMTITLE = "или больше зон - сохранять";
KARMA_WINEL_DBCLEANKEEPIFZONENUMTOOLTIP = {
		"Оставляеть если есть совместно пройденые подземелья.",
		"Оставляет записи если количество совместно пройденых зон не меньше указанных.",
		"Если игнорировать PVP области/зоны, то они небудут защитоваться.",
		"(Эта проверка выполняется после проверок на заметки и кросс-сервер.)"
	};

KARMA_WINEL_DBCLEANIGNOREPVPZONESTITLE = "Игнорировать PvP области/зоны в подсчете";
KARMA_WINEL_DBCLEANIGNOREPVPZONESTOOLTIP = {
		"Игнорировать PvP области/зоны",
		"При подсчете посещенных областей/зон, PvP области/зоны учитываться небудут.",
		"PVP области известны аддону, но придется один раз побывать в них,",
		"чтобы аддон смог правильно их определить и отметить.",
		"(Эта проверка выполняется после проверок на заметки и кросс-сервер.)"
	};

KARMA_WINEL_DBCLEAN_TESTBUTTON = "Тест очистки";
KARMA_WINEL_DBCLEAN_TESTTOOLTIP = "Это действие НИЧЕГО не удалит из вашей базы данных.\nОно выводит (в окно чата) сколько и какие записи будут удалены.\nЧтобы удалить записи из базы данных вы должны ввести\nкоманду /karma clean (при этом ненаходясь в группе).\n";

--

KARMA_WINEL_OPTIONSTOOLTIPAREATITLE = "Подсказка";
KARMA_WINEL_TIPS_SHIFTREQ_CHECKBOXTITLE = "Показывать в подсказках только при зажатом /Shift";
KARMA_WINEL_KARMATIPSCHECKBOXTITLE = "Показывать рейтинг в подсказках";
KARMA_WINEL_PLAYEDTHISCHECKBOXTITLE = "Показывать в подсказках игровое время текущего персонажа";
KARMA_WINEL_PLAYEDTOTALCHECKBOXTITLE = "Показывать в подсказках общее игровое время всех персонажей";
KARMA_WINEL_NOTETIPSCHECKBOXTITLE = "Показывать заметки в подсказках";
KARMA_WINEL_TIPS_SKILL_SCHECKBOXTITLE = "Показывать навык в подсказках";
KARMA_WINEL_TIPS_TALENTS_SCHECKBOXTITLE = "Показывать таланты в подсказках";
KARMA_WINEL_TIPS_TERROR_CHECKBOXTITLE = "Показывать достижения в подсказках";
KARMA_WINEL_TIPS_ALTS_SCHECKBOXTITLE = "Показывать твинков в подсказках";
KARMA_WINEL_TT_HELP_BOXTITLE = "Показывать помощь в подсказках элементов интерфейса";
KARMA_WINEL_TT_LFMADDKARMA_BOXTITLE = "Вставлять информацию в подсказки для игроков LFM окна";

KARMA_WINEL_OPTIONSOTHERAREATITLE = "Другие настройки:";
KARMA_WINEL_TARGETCOLOREDCHECKBOXTITLE = "Target background " .. KARMA_ITSELF .. "-colored";
KARMA_WINEL_QCACHWARNCHECKBOXTITLE = "Передупреждать о (частично) поврежденном логе квестов";
KARMA_WINEL_MAINWNDTAB_DROPDOWNTITLE = "Главное окно:\nначальная вкладка при открытии";
KARMA_WINEL_AUTOCHECKTALENTSCHECKBOXTITLE = "Автоматическая загрузка талантов для игроков группы/рейда";
KARMA_WINEL_MINIMAPICONHIDE_TITLE = "Скрыть кнопку у миникарты";
KARMA_WINEL_QUESTSIGNOREDAILIES_TITLE = "Недобавлять ежедневные квесты в список квестов";
KARMA_WINEL_UPDATEWHILEAFK_TITLE = "(Пытаться) обновлять игроков если ушли в AFK";
KARMA_WINEL_CONTEXTMENUDEACTIVATE_TITLE = "Не вставлять функции Karma в контекстные меню";
KARMA_WINEL_CONTEXTMENUDEACTIVATE_TOOLTIP = {
		"Дополнительные функции контекстного меню:",
		"Если у вас происходят частые сбои контекстного",
		"меню то данный пункт лучше включить."
	};
KARMA_WINEL_DBSPARSETABLES_TITLE = "Режим облегченной БД: не добавляет все записи в таблицы";
KARMA_WINEL_DBSPARSETABLES_TOOLTIP = {
		"Режим облегченной БД:",
		"В базу можно сразу добавить все таблицы, которые могут быть использованы",
		"или добавлять только необходимые по мере добавления новых игроков.",
		"Вы можете сэкономить немного памяти по сравнению с обычным режимом,",
		"интерфейс при этом немного меняется, но оба режима могут быть неудобными.",
		"--",
		"Advantage of adding all tables: on the tracked data you can select one char",
		"of yours and then click through the players list without having to re-select",
		"Disadvantage of adding all tables: used memory is usually a lot higher than",
		"really necessary",
		"--",
		"Advantage of sparse tables: quite some less memory consumption",
		"Disadvantage of sparse tables: the selection of your related char on the",
		"tracked data page kind of has a life on its own...",
		"--",
		"In these days of gigabytes of memory, it really isn't that problematic",
		"if " .. KARMA_ITSELF .. " takes some dozen megabytes. The relevant question is",
		"really the \"memory churn\" (i.e. how much memory it unnecessarily",
		"temporarily requests and disposes - which it does really very little).",
		"--",
		"Still, some (older) people are scared about the amount of memory " .. KARMA_ITSELF .. " uses,",
		"so here's a way to reduce it a bit. :-)",
		"--",
		"Enabling this option does not walk over the database to clean out the already",
		"existing but unused tables. To do that, you have to issue a command (which",
		"eats A LOT OF CPU TIME, DON'T PANIC, IT'S NOT CRASHED, JUST WORKING)",
		"on each server/faction you play on: '" .. KARMA_CMDSELF .. " dbsparse * [execute]'",
		"(Without execute it will list how much it *would* remove, but does not.",
		"If you actually crash, you can do it letter per letter instead of all in",
		"one swoop. Replace * with A*, B*, C* and so on.)"
	};

KARMA_WINEL_OPTIONSVIRTUALKARMAAREATITLE = "Автоматически начислять рейтинг за игровое время (Тестовый режим!)";
KARMA_WINEL_TIMEKARMA_ENABLE_TITLE = "Автоматически начислять рейтинг за игровое время";
KARMA_WINEL_TIMEKARMA_MINVAL_TITLE = "Минимум включения авторейтинга: ";
KARMA_WINEL_TIMEKARMA_FACTOR_TITLE = "Рейтинг за час: ";
KARMA_WINEL_TIMEKARMA_SKIPBGTIME_TITLE = "Не добавлять время от БГ (обратной силы не имеет)";

KARMA_WINEL_SHARINGAREATITLE = "Настройки обмена:";
KARMA_WINEL_SHARING_KARMALEVEL = "Обмен значениями рейтингов:";
KARMA_WINEL_SHARING_PUBLICNOTELEVEL = "Обмен публичными заметками:";
KARMA_WINEL_SHARING_CHANNELNAME = "Канал обмена server-wide:";
KARMA_WINEL_SHARING_CHANNELAUTOJOINHIDE = "Автоматический вход на канал и скрытие (при входе в игру)";

KARMA_SHARELEVELS = {};
KARMA_SHARELEVELS.L0 = "никогда";
KARMA_SHARELEVELS.L1 = "всегда";
KARMA_SHARELEVELS.L2 = "в гильдии";
KARMA_SHARELEVELS.L3 = "доверенным (n.y.i.)";

KARMA_WINEL_COREFEATURESAREATITLE = "Стандартные свойства Karma:";
KARMA_WINEL_TRACKINGDISABLEQUESTSTITLE = "Отключить слежение за квестами в группе";
KARMA_WINEL_TRACKINGDISABLEACHIEVEMENTSTITLE = "Отключить слежение за достижениями в группе";
KARMA_WINEL_TRACKINGDISABLEACHIEVEMENTTERRORTITLE = "Отключить слежение за достижениями на босах";
KARMA_WINEL_TRACKINGDISABLEREGIONSTITLE = "Отключить слежение за подземельями в группе";
KARMA_WINEL_TRACKINGDISABLEZONESTITLE = "Отключить слежение за зонами в группе";

--
--
----
--
--

KARMA_WINEL_MINIMENU_TOOLTIP1 = "Левая кнопка открывает главное окно";
KARMA_WINEL_MINIMENU_TOOLTIP2 = "Средняя кнопка открывает окно игроков онлайн (LFM)";
KARMA_WINEL_MINIMENU_TOOLTIP3 = "Правая кнопка открывает меню";

KARMA_WINEL_MINIMENU_KARMA = KARMA_ITSELF;
KARMA_WINEL_MINIMENU_TARGETIS = ": Текущая цель ";
KARMA_WINEL_MINIMENU_TARGETNONE = ": Цель не выбрана!";
KARMA_WINEL_MINIMENU_KARMACHANGE = "Изменить рейтин игрока на ...";
KARMA_WINEL_MINIMENU_KARMAADDCHAR = "Добавить игрока в список";
KARMA_WINEL_MINIMENU_KARMADELCHAR = "Удалить игрока из списка";
KARMA_WINEL_MINIMENU_KARMASELCHAR = "Выбрать игрока в главном окне Karma";

KARMA_WINEL_MINIMENUSUB_INCREASE = "Повысить рейтинг на ...";
KARMA_WINEL_MINIMENUSUB_PLUS = " + ";
KARMA_WINEL_MINIMENUSUB_DECREASE = "Снизить рейтинг на ...";
KARMA_WINEL_MINIMENUSUB_MINUS = " - ";

KARMA_WINEL_REASON_NONE = "без заметки"; -- причины рейтинга через меню
KARMA_WINEL_REASON_SKILL = "навык";
KARMA_WINEL_REASON_MANNERS_UNCATEGORIZED = "манеры"; 

KARMA_WINEL_REASON_NINJA = "нидер";
KARMA_WINEL_REASON_KSER = "mob 'thief' (rares, quest mobs, mass tagging, etc.)";
KARMA_WINEL_REASON_BOT = "бот";
KARMA_WINEL_REASON_MANNERS_CONCEITED = "m:conceited";
KARMA_WINEL_REASON_MANNERS_RUDE = "m:rude";
KARMA_WINEL_REASON_MANNERS_SCAM = "m:scam";
KARMA_WINEL_REASON_MANNERS_DRAMAQUEEN = "m:drama queen";
KARMA_WINEL_REASON_SPAM_UNCATEGORIZED = "спам";
KARMA_WINEL_REASON_SPAM_ALLCAPS = "s:ALLCAPS";
KARMA_WINEL_REASON_SPAM_WRONG_CHANNEL = "s:channel abuse";
KARMA_WINEL_REASON_SPAM_SPEED = "s:speedy repetitions";

KARMA_WINEL_REASON_HELP_KILL = "помог убить";
KARMA_WINEL_REASON_HELP_INFO = "помог информацией";
KARMA_WINEL_REASON_HELP_ORGANIZE = "помог организовать";
KARMA_WINEL_REASON_MANNERS_MODEST = "m:modest";
KARMA_WINEL_REASON_MANNERS_POLITE = "m:polite"; 
KARMA_WINEL_REASON_MANNERS_GENEROUS = "m:generous";
KARMA_WINEL_REASON_MANNERS_GRACIOUS = "m:gracious";

KARMA_BINDING_HEADER_TITLE = KARMA_ITSELF .. ": окна";  -- назначение горячих клавиш
KARMA_BINDING_WINDOW_TITLE = "Открыть/закрыть главное окно";
KARMA_BINDING_WINDOW2_TITLE = "Открыть/закрыть окно LFM";

-- spelling here is likely off...
KARMA_PVPZONE_WSG = "Ущелье Песни Войны";
KARMA_PVPZONE_AB = "Низина Арати";
KARMA_PVPZONE_AV = "Альтеракская долина";
KARMA_PVPZONE_ES = "Око бури";
KARMA_PVPZONE_SA = "Берег Древних";
KARMA_PVPZONE_IOC = "Остров Завоеваний";

KARMA_PVPZONE_WG = "Озеро Ледяных Оков";

KARMA_WINEL_LISTMEMBERTIP_JOINED_ATALL_PRE = "Последняя встреча с (";
KARMA_WINEL_LISTMEMBERTIP_JOINED_ATALL_POST = "): ";
KARMA_WINEL_LISTMEMBERTIP_JOINED_CHAR = "Последняя встреча с этим персонажем: ";
KARMA_WINEL_LISTMEMBERTIP_UPDATE_OK = "Обновлено: ";
KARMA_WINEL_LISTMEMBERTIP_UPDATE_FAIL = "Попытка обновления: ";
KARMA_WINEL_LISTMEMBERTIP_UPDATE_NEVER = "Не обновлялся...";

KARMA_CHANNELNAME_LFG = "LookingForGroup";

--
--
--

KARMA_CLASS_DRUID_M = "Друид";
KARMA_CLASS_DRUID_F = "Друид";
KARMA_CLASS_HUNTER_M = "Охотник";
KARMA_CLASS_HUNTER_F = "Охотница";
KARMA_CLASS_MAGE_M = "Маг";
KARMA_CLASS_MAGE_F = "Маг";
KARMA_CLASS_PALADIN_M = "Паладин";
KARMA_CLASS_PALADIN_F = "Паладин";
KARMA_CLASS_PRIEST_M = "Жрец";
KARMA_CLASS_PRIEST_F = "Жрица";
KARMA_CLASS_ROGUE_M = "Разбойник";
KARMA_CLASS_ROGUE_F = "Разбойница";
KARMA_CLASS_SHAMAN_M = "Шаман";
KARMA_CLASS_SHAMAN_F = "Шаманка";
KARMA_CLASS_WARRIOR_M = "Воин";
KARMA_CLASS_WARRIOR_F = "Воин";
KARMA_CLASS_WARLOCK_M = "Чернокнижник";
KARMA_CLASS_WARLOCK_F = "Чернокнижница";

KARMA_CLASS_DEATHKNIGHT_M = "Рыцарь смерти";
KARMA_CLASS_DEATHKNIGHT_F = "Рыцарь смерти";

KARMA_RACES_ALLIANCE_LOCALIZED =
	{
		KRA_DRAENEI	= "Дреней",
		KRA_DWARF	= "Дворф",
		KRA_GNOME	= "Гном",
		KRA_HUMAN	= "Человек",
		KRA_NIGHTELF	= "Ночной эльф"
	};

KARMA_RACES_HORDE_LOCALIZED =
	{
		KRH_BLOODELF	= "Эльф крови",
		KRH_ORC		= "Орк",
		KRH_TAUREN	= "Таурен",
		KRH_TROLL	= "Тролль",
		KRH_UNDEAD	= "Нежить"
	};

KARMA_RACES_ALLIANCE_MALE =
	{
		DRAENEI		= "Дреней",
		DWARF		= "Дворф",
		GNOME		= "Гном",
		HUMAN		= "Человек",
		NIGHTELF	= "Ночной эльф"
	};

KARMA_RACES_HORDE_MALE =
	{
		BLOODELF	= "Эльф крови",
		ORC		= "Орк",
		TAUREN		= "Таурен",
		TROLL		= "Тролль",
		UNDEAD		= "Нежить"
	};

KARMA_RACES_ALLIANCE_FEMALE =
	{
		DRAENEI		= "Дреней",
		DWARF		= "Дворф",
		GNOME		= "Гном",
		HUMAN		= "Человек",
		NIGHTELF	= "Ночная эльфийка"
		};

KARMA_RACES_HORDE_FEMALE =
	{
		BLOODELF	= "Эльфийка крови",
		ORC		= "Орк",
		TAUREN		= "Таурен",
		TROLL		= "Тролль",
		UNDEAD		= "Нежить"
	};

KARMA_MISSING_INFO = "???";
KARMA_MISSING_INFO_SMALL = "?";

KARMA_TALENTS_LOCALIZED =
	{
		KARMA_TALENT_HPS = "HPS",
		KARMA_TALENT_TANK = "TANK",
		KARMA_TALENT_DPS = "DPS",
		KARMA_TALENT_FERAL = "FERAL",
		KARMA_TALENT_MELEE = "M",
		KARMA_TALENT_RANGED = "R"
	};

KARMA_ABILITIES_CC_LOCALIZED =
	{
		KARMA_TALENT_CC_CC0 = "C.",
		KARMA_TALENT_CC_CC1 = "C1",
		KARMA_TALENT_CC_CC2 = "C2",
	};

KARMA_TARGETS_CC_LOCALIZED =
	{
		KARMA_MONSTER_HUMAN = "Гуманойд",
		KARMA_MONSTER_UNDEAD = "Нежить",
		KARMA_MONSTER_ELEMENT = "Элементаль",
		KARMA_MONSTER_BEAST = "Зверь",
		KARMA_MONSTER_DRAKE = "Дракон"
	};

KARMA_ABILITIES_AE_LOCALIZED =
	{
		KARMA_TALENT_AE_M1 = "AE1",
		KARMA_TALENT_AE_AE = "AEx"
	};

-- SKILL: 0..100
KARMA_SKILL_LEVELS_COMPLEX = 
	{
	-- able to find their way?
	-- able to understand a quest?
	-- able to follow an order?
	-- able to assist on a target?
	-- able to CC one target?
	-- able to CC one target and still assist on main?
	-- able to CC two targets?
		[0] = "eBayed?",
		[5] = "missing elementary game skills: read map/understand qlog",
		[10] = "missing basic game skill: follow the group",
		[15] = "missing basic group skill: follow an order/cooperative play",
		[20] = "able to follow elementary orders: follow, attack, stop",
		[25] = "can tank *one* target",
		[30] = "tolarable to useful in a regular instance",
		[35] = "able to attack the right target (i.e. assist)",
		[40] = "able to CC one target once",
		[45] = "can tank *two* targets",
		[50] = "able to CC one target repeatedly & continuously",
		[55] = "able to CC while staying on main target",
		[60] = "can tank *three* targets while keeping an eye on the healer",
		[65] = "able to automatically re-assist on change in CC",
		[70] = "tolarable to useful in a heroic instance",
		[75] = "able to CC dynamically (e.g. changing CC to mob on healer)",
		[80] = "able to CC *two* targets (i.e. kiting)",
		[85] = "can tank *four* targets",
		[100] = "a true hero"
	};

KARMA_SKILL_LEVELS_SIMPLE =
	{
		[0] = "|cFFFF2020РАК !!!|r",
		[20] = "|cFFffa500Криворукий|r",
		[40] = "|cFFFFFF00Так себе|r",
		[60] = "|cFFCCFF00Нормальный|r",
		[80] = "|cFF66FF00Рейдер|r",
		[100] = "|cFF00e600Мастер!|r"
	};

-- GEAR: 0..100
KARMA_GEAR_PVE_LEVELS = 
	{
		[0] = "PvE |cFF008000Зелень|r",
		[35] = "PvE |cFF0000ffСинька|r",
		[64] = "PvE |cFFb60affФиолет пред Т9|r",
		[66] = "PvE |cFFb60aff~5,1к 4T9|r",
		[68] = "PvE |cFFb60aff~5,3к 2T10|r",
		[70] = "PvE |cFFb60aff~5,6к 4T10 и выше|r",
		[91] = "PvE |cFFb60aff~6,1к 4Т10 половина бис|r",
		[94] = "PvE |cFFb60aff~6,4к 4-6 вещей до бис|r",
		[97] = "PvE |cFFb60aff~6,5к 1-3 вещей до бис|r",
		[100] = "PvE |cFFb60affФУЛ БИС|r"
	};

-- GEAR: 0..100
KARMA_GEAR_PVP_LEVELS = 
	{
		[0] = "PvP |cFF008000Зелень|r",
		[25] = "PvP |cFF0000ffСинька|r",
		[35] = "PvP |cFFb60affФиолет|r",
		[40] = "PvP |cFFb60aff4А7|r",
		[50] = "PvP |cFFb60aff2А8|r",
		[65] = "PvP |cFFb60aff4А8|r",
		[80] = "PvP |cFFb60aff4-6 вещей до фул бис|r",
		[90] = "PvP |cFFb60aff1-3 вещей до фул бис|r",
		[100] = "PvP |cFFb60affФУЛ БИС|r"
	};

KARMA_LEVEL_RESET = "Сбросить выбор";

KARMA_WINEL_SCROLLTOSELECTION_BUTTON = "Найти в списке";
KARMA_WINEL_TRACKINGDATA_BUTTON = "Статистика";
KARMA_WINEL_OTHERDATA_BUTTON = "Заметки и подробности";
KARMA_WINEL_OTHERDATA_TITLE = "Навык и экипировка:";
KARMA_WINEL_CHOSENPLAYERSKILLTITLE = "Навык";
KARMA_WINEL_CHOSENPLAYERGEARPVETITLE = "PvE шмот";
KARMA_WINEL_CHOSENPLAYERGEARPVPTITLE = "PvP шмот";

KARMA_WINEL_LFM_TITLE = "Karma: LFM";
KARMA_WINEL_LIST1_TITLE = "Найденые игроки";
KARMA_WINEL_POPULATE_TITLE = "Проверка игроков";
KARMA_WINEL_LIST2_TITLE = "Выбраные игроки";

KARMA_WINEL_SENDMESS_TITLE = "next send also to this player";
KARMA_WINEL_SENTMESS_TITLE = "already sent a message";
KARMA_WINEL_POSREPLY_TITLE = "got a positive reply";

KARMA_WINEL_MESSAGE_TO_SEND_TOOLTIP =	   "Это сообщение будет отправлено с помощью кнопки >|cFFffff00Отправить сообщение|r<.\n"
					.. "Можно использовать маску %t которая будет заменена на имя фактического получателя.\n"
					.. "(\"Привет %t!\" отправленное Джо будет выглядеть как \"Привет Джо!\")\n"
					.. "If you selected an (offline) alt as candidate, additionally %a\n"
					.. "in the text will be replaced with the requested alt's name.\n"
					.. "(\"Hello %t, we need you as %a!\" is sent to Joe playing Jack as\n"
					.. " \"Hello Jack, we need you as Joe!\")";
KARMA_WINEL_SENDMESS_TOOLTIP =	   "Если этот флажок установлен,\n"
				.. "сообщение (написанное внизу)\n"
				.. "будет отправлено этому игроку\n"
				.. "при нажатии на кнопку\n"
				.. ">|cFFffff00Отправить сообщение|r<";
KARMA_WINEL_SENTMESS_TOOLTIP = "This box gets *automatically* checked,\n"
							.. "after you sent the player a message here.";
KARMA_WINEL_POSREPLY_TOOLTIP = "Если этот флажок установлен,\n"
							.. "этот игрок получит приглашение\n"
							.. "в вашу группу когда вы нажмете\n"
							.. "кнопку >|cFFffff00Пригласить игроков|r<\n"
							.. "|cFFb3b3b3(это возможно только если: вы \n"
							.. "лидер и группа еще не полная).|r";

KARMA_WINEL_QUERYNOTESPUB_BTNTITLE = "Запрос общих заметок";

KARMA_WINEL_SEND_TITLE  = "Отправка сообщения\nвыбранным игрокам";
KARMA_WINEL_SENDMESSAGE_BTNTITLE = "Отправить сообщение";

KARMA_WINEL_INVITE_TITLE  = "Отправка приглашений\nвыбранным игрокам";
KARMA_WINEL_INVITE_BTNTITLE = "Пригласить игроков";

KARMA_WINEL_ALTADDBUTTON = "Отметить как твинк персонажа: ";
KARMA_WINEL_ALTREMBUTTON = "Удалить из списка твинков";

KARMA_WINEL_POSTTOMEMBER = "Шепнуть информацию об: ";                          -- отправляет в приват информацию о выбранном игроке 

KARMA_WINEL_POPULATE_CHANNEL_TITLE = "Проверка канала для игроков:";
KARMA_WINEL_POPULATE_CHANNELS_TITLE = "Проверка всех каналов для игроков";
KARMA_WINEL_POPULATE_LEVEL_TITLE = "Диапазон уровней (проверка класса) :";
KARMA_WINEL_POPULATE_CLASS_TITLE = "Проверка класса для игроков:";
KARMA_WINEL_POPULATE_CLASSES_TITLE = "Проверка всех игроков на классы\n!! ЭТО ЗАНИМАЕТ ДОЛГОЕ ВРЕМЯ !!\n(приблизительно 2м 30сек)";
KARMA_WINEL_POPULATE_GUILD_TITLE = "Проверка гильдии:";

KARMA_WINEL_FILTERLIST1_TITLE = KARMA_WINEL_FILTER;
KARMA_WINEL_FILTERLIST1_KARMAMIN_TITLE = "мин. рейтинг: ";
KARMA_WINEL_FILTERLIST1_KARMAREQ_TITLE = "Только игроки занесенные в базу\n(имеющие рейтинг)";
KARMA_WINEL_FILTERLIST1_SKILLMIN_TITLE = "мин. навык: ";
KARMA_WINEL_FILTERLIST1_CLASSREQ_TITLE = "Только определенные классы\n|cFFb3b3b3(не серые записи)|r";
KARMA_WINEL_FILTERLIST1_LEVELRANGE_TITLE = "Уровни: ";

KARMA_WINEL_LFMALTS = "+Твины";

--
--
--

KARMA_MSG_OOPS = "Oops. Internal error.";
KARMA_MSG_OOPS_IDENTITY = "Oops! Fatal identity crisis detected! Cannot sort names by xp/played. :-(";
KARMA_MSG_OOPS_NOTIMPLEMENTED = "Not yet implemented";

KARMA_MSG_CANNOT_PRE = "Cannot ";
KARMA_MSG_CANNOT_POST = "";
KARMA_MSG_UNKNOWN = " unknown.";

KARMA_MSG_SHORT_DAY = "д";
KARMA_MSG_SHORT_HOUR = "ч";
KARMA_MSG_SHORT_MINUTE = "м";
KARMA_MSG_SHORT_SECOND = "с";

KARMA_MSG_ON = "on";
KARMA_MSG_OFF = "off";

KARMA_MSG_CONFIG_ISNOWON = " теперь |cFF008000ВКЛЮЧЕНО.|r";
KARMA_MSG_CONFIG_ISNOWOFF = " теперь |cFFFF2020ОТКЛЮЧЕНО.|r";

KARMA_MSG_COMMAND = "Command ";
KARMA_MSG_COMMAND_NEEDTARGETORARGUMENT = " used with no target nor commandline argument.";
KARMA_MSG_COMMAND_MISSINGARG = "Отсутствует обязательный аргумент";
KARMA_MSG_COMMAND_MISSINGARGS = "Отсутствуют необходимые аргументы";
KARMA_MSG_COMMAND_NOTMEMBER = "not on " .. KARMA_ITSELF .. "'s list.";

KARMA_MSG_COMMANDQUEUE_FULL1 = "Command queue must be empty for this. Current status";
KARMA_MSG_COMMANDQUEUE_FULL2 = " commands pending.";

KARMA_MSG_HELPINSECONDWINDOW = "Смотри краткую справку в дополнительном окне...";
KARMA_MSG_HELPCOMMANDLIST = "Полный список команд:";

KARMA_MSG_PLAYER_REQARG = "<player>";
KARMA_MSG_REMOVE_COMPLETED = " was removed from the " .. KARMA_ITSELF .. "'s list of yours.";

KARMA_MSG_ADDMEMBER_ADDED = " was added to the " .. KARMA_ITSELF .. "'s list of yours.";
KARMA_MSG_IGNOREMEMBER_ADDED = " was added to " .. KARMA_ITSELF .. "'s list, and ignored.";
KARMA_MSG_ADDORIGNMEMBER_OFFLINE = " was not found. They may not be currently logged on.";

KARMA_MSG_UPDATEMEMBER_UPDATED = " updated, location: ";
KARMA_MSG_UPDATEMEMBER_ONLINE = " в игре, игровая зона: ";
KARMA_MSG_UPDATEMEMBER_OFFLINE = " was not found, couldn't update.";

KARMA_MSG_CHECKING_FOR = "Проверка для ";
KARMA_MSG_CHECKCHANNEL_ONE = "Checking against channel";
KARMA_MSG_CHECKCHANNEL_ALL = "Queueing checks for all channels you're in";
KARMA_MSG_CHECKCHANNEL_RESULTS = "Results from channel";
KARMA_MSG_CHECKCHANNEL_TOTAL1 = "CheckChannel";
KARMA_MSG_CHECKCHANNEL_TOTAL2 = " names parsed, ";
KARMA_MSG_CHECKCHANNEL_TOTAL3 = " recognized.";

KARMA_MSG_WHORESULT_1 = "В результате найдено как >";
KARMA_MSG_WHORESULT_2 = "<: ";
KARMA_MSG_WHORESULT_3 = " игроков";
KARMA_MSG_WHORESULT_4 = " { )-: only partial results :-( }";

KARMA_MSG_WHOCATCHED_GOTNOTES = "Заметки для ";
KARMA_MSG_WHOCATCHED_NONOTES = "Нет заметок для ";

KARMA_MSG_CONFIG_AUTOIGNORE = "Автоигнор";

KARMA_MSG_QCACHE_SECONDWINDOW = "Список кэша заданий в дополнительном окне..";
KARMA_MSG_QCACHE_SUBLISTING = "Sublisting: ";
KARMA_MSG_QCACHE_COMPLETE = "complete = ";
KARMA_MSG_QCACHE_OBJECTIVESPECIAL = "(discovery/other special objective)";

KARMA_MSG_INSPECT_OVERRIDE1 = "Inspect request for ";
KARMA_MSG_INSPECT_OVERRIDE2 = " was overriden by other AddOn or UI action. Deferring until ";
KARMA_MSG_INSPECT_OVERRIDE3 = " is processed...";

KARMA_MSG_CONFIG_TIP_KARMA = "Рейтинг в подсказках";
KARMA_MSG_CONFIG_TIP_NOTES = "Заметки в подсказках";

KARMA_MSG_FILTER_SET = "Set filter.";
KARMA_MSG_FILTER_CLEARED = "Cleared filter.";

-- empty comment for line sync
KARMA_MSG_UPDATE_RANDOM_EMPTYBUCKET1 = "No (random) member starting with";
KARMA_MSG_UPDATE_RANDOM_EMPTYBUCKET2 = "found to update.";

KARMA_MSG_CONFIG_QCACHEWARN = "Warning for collapsed questlog";

KARMA_MSG_CHECKCLASS_CLASS = "<class>";
KARMA_MSG_CHECKCLASS_UNK1 = "Failed to decode class";
KARMA_MSG_CHECKCLASS_UNK2 = ", will run over all races.";
KARMA_MSG_CHECKCLASS_QUEUEING_ONE = "Запущена проверка класса ";
KARMA_MSG_CHECKCLASS_DONE1 = "Проверка класса >";
KARMA_MSG_CHECKCLASS_DONE2 = "< завершена.";

KARMA_MSG_CHECKCLASS_QUEUEING_ALL = "Запущена проверка для всех классов. Это займет некоторое время...";
KARMA_MSG_CHECKCLASS_DONE_QUICK = "Fast checks for all classes finished. Slow checks are still pending...";
KARMA_MSG_CHECKCLASS_DONE_ALL = "Проверка всех классов завершена.";

KARMA_MSG_RESETGUI = "Расположение значка у мини-карты, главного окна и окна LFM, сброшены.";

KARMA_MSG_CONFIG_AUTOTALENTS = "Автоматическая проверка талантов";

KARMA_MSG_CONFIG_SKILLMODEL_ISNOW = "Список навыков установлен как";

KARMA_MSG_FIELDINIT_ERROR_VALUE = "Oops! Trying to initialize <unknown field> to ";
KARMA_MSG_FIELDINIT_ERROR_TABLE = "<table>";

KARMA_MSG_TIP_SKILL = "Навык";                                      -- в подсказке
KARMA_MSG_TIP_TALENT = "Таланты";                                   -- в подсказке
KARMA_MSG_TIP_ALTS = "Твинки";                                      -- в подсказке

KARMA_MSG_QCACHE_WARNING = "WARNING! Quest cache is incomplete, questlog is partially collapsed, might lose some quest info...";

KARMA_MSG_DBCLEAN_EXTRAARG = "Won't clean DB: Found extra argument. Did you want to try '" .. KARMA_CMDSELF .. " clean dryrun'?";
KARMA_MSG_DBCLEAN_INGROUP = "Cannot clean DB: you're in a group.";
KARMA_MSG_DBCLEAN_PVPREGIONMARKED = "помечено как PvP область.";

KARMA_MSG_DBCLEAN_PRETEXT_NORMAL = "Очистка записей базы данных";
KARMA_MSG_DBCLEAN_RESULT_NORMAL1 = "Удалено ";
KARMA_MSG_DBCLEAN_RESULT_NORMAL2 = " записей из БД, всего теперь";

KARMA_MSG_DBCLEAN_PRETEXT_DRYRUN = "Showing entry status of DB";
KARMA_MSG_DBCLEAN_RESULT_DRYRUN1 = "Would have cleaned ";
KARMA_MSG_DBCLEAN_RESULT_DRYRUN2 = " entries from DB, total count then";

KARMA_MSG_DBCLEAN_RESULT_3 = " записей.";

KARMA_MSG_REMOVE_ISINGROUP1 = "remove";
KARMA_MSG_REMOVE_ISINGROUP2 = ", member of current group!";

KARMA_MSG_TIP_LEVEL = "Ур.";

KARMA_MSG_AUTOIGNORE_GUILD = "Guild invite from ";
KARMA_MSG_AUTOIGNORE_PARTY = "Party invite from ";
KARMA_MSG_AUTOIGNORE_TRADE = "Trade request from ";
KARMA_MSG_AUTOIGNORE_DUEL = "Duel request from ";
KARMA_MSG_AUTOIGNORE_2 = KARMA_WINEL_FRAG_SPACE .. KARMA_ITSELF .. ") auto-declined. (Threshold ";
KARMA_MSG_AUTOIGNORE_3 = KARMA_WINEL_FRAG_SPACE .. KARMA_ITSELF .. ".)";

KARMA_MSG_MARKUP_WHISPER = " whispers:\32";
KARMA_MSG_MARKUP_CHANNEL = ":\32";

KARMA_MSG_CHATWND_ISNOW = " chat window is now";
KARMA_MSG_CHATWND_OVERTHERE = "over there -->";
KARMA_MSG_CHATWND_THISONE = " this one.";
KARMA_MSG_CHATWND_DEFAULTAGAIN = " back to... default!";
KARMA_MSG_CHATWND_UNSET = " unset.";

KARMA_MSG_CHATWND_DEFAULT = "Default";
KARMA_MSG_CHATWND_SECONDARY = "Secondary";
KARMA_MSG_CHATWND_DEBUG = "DEBUG";

KARMA_MSG_VERSION_NEW1 = "Newer version available: ";
KARMA_MSG_VERSION_NEW2 = " (since ";
KARMA_MSG_VERSION_NEW3 = ")";

KARMA_MSG_LFM_LIST1TIP_ALTS = "Alts";

KARMA_MSG_CHATSETUP_AUTO = "[autoassigned] ";
KARMA_MSG_CHATSETUP_1 = " (";
KARMA_MSG_CHATSETUP_2_DEFAULT = "основные";
KARMA_MSG_CHATSETUP_2_EXTRA = "дополнительные";
KARMA_MSG_CHATSETUP_2_DEBUG = "отладочные";
KARMA_MSG_CHATSETUP_3 = " сообщения -> ";
KARMA_MSG_CHATSETUP_4 = ")";
KARMA_MSG_CHATSETUP_DONE = "Определены окна чата";

KARMA_MSG_ALT_REQARG = "<alt>";
KARMA_MSG_ALT_REQARGS = "<alt1> <alt2>";

KARMA_MSG_ALT_LIST_NOTMEMBER1 = "Can't list alts of >";
KARMA_MSG_ALT_LIST_NOTMEMBER2 = "<";
KARMA_MSG_ALT_LIST_NOALTS1 = "У игрока >";
KARMA_MSG_ALT_LIST_NOALTS2 = "< отсутствуют твины.";
KARMA_MSG_ALT_LIST_PREFIX = "AltID ";
KARMA_MSG_ALT_LIST_OOPS_NOALTS1 = "Oops? AltID set, but no alts for >";
KARMA_MSG_ALT_LIST_OOPS_NOALTS2 = "<.";

KARMA_MSG_ALT_REM_NOTMEMBER1 = "Can't remove >";
KARMA_MSG_ALT_REM_NOTMEMBER2 = "< from any alt group";
KARMA_MSG_ALT_REM_NOALTID1 = ">";
KARMA_MSG_ALT_REM_NOALTID2 = "< не входит в группу твинов.";
KARMA_MSG_ALT_REM_DONE1 = ">";
KARMA_MSG_ALT_REM_DONE2 = "< удален из группы твинов.";
KARMA_MSG_ALT_REM_OOPS_NOALTS1 = "Oops? AltID set, but no alts for >";
KARMA_MSG_ALT_REM_OOPS_NOALTS2 = "<? Resetting altID";

KARMA_MSG_ALT_ADD_SAMEPLAYER = "Can't alt-link the same player unto themselves. Try *different* players...";
KARMA_MSG_ALT_ADD_NOTMEMBER = "Can't alt-link the two players: one or both are not known to " .. KARMA_ITSELF .. ".";
KARMA_MSG_ALT_ADD_ALREADYSAME = "The two players are already in the same alt group.";
KARMA_MSG_ALT_ADD_NOMERGE = "Merging two different alt groups is not implemented. Sorry.";
KARMA_MSG_ALT_ADD_DONE1 = " и ";
KARMA_MSG_ALT_ADD_DONE2 = " теперь в группе твинов №";

KARMA_MSG_CHECKGUILD_NOARG = "<guild>";

KARMA_MSG_PARTYJOINED_LOWKARMA1 = "WARNING";
KARMA_MSG_PARTYJOINED_LOWKARMA2 = " is - with just ";
KARMA_MSG_PARTYJOINED_LOWKARMA3 = " " .. KARMA_ITSELF .. " - below the minimum wanted value of ";
KARMA_MSG_PARTYJOINED_LOWKARMA4 = " " .. KARMA_ITSELF .. "!";

KARMA_MSG_TALENT_OTHERFRAMES = "Can't inspect talents: multiple frames being registered, the result is not definite.";

KARMA_UNITPOPUP_CHARADD = "Karma: Добавить в список";
KARMA_UNITPOPUP_CHARDEL = "Karma: Удалить из списка";

KARMA_UNITPOPUP_INCREASE = "Повысить рейтинг на ";
KARMA_UNITPOPUP_DECREASE = "Снизить рейтинг на ";

KARMA_UNITPOPUP_SELECT = "Выбрать в списке";

KARMA_UNITPOPUP_PUBNOTE_CHECKGUILD = "Запросить публичные заметки в гильдии";
KARMA_UNITPOPUP_PUBNOTE_CHECKCHANNEL = "Запросить публичные заметки в канале";

KARMA_XFACTION_MENU_CHARADD = "Add player";
KARMA_XFACTION_MENU_CHARNOTE = "Add note (written into FILTER editbox) to player";
KARMA_XFACTION_MENU_CHARCHECK = "Check if player is known to " .. KARMA_ITSELF .. " on the 'other side'";

KARMA_MSG_NOTONKARMASLIST1 = "Can't change " .. KARMA_ITSELF .. " value of ";
KARMA_MSG_NOTONKARMASLIST2 = " You must 'add' them first (so " .. KARMA_ITSELF .. " knows about them).";

--
--
--

-- Tooltips: any UI element, via extra routines
KARMA_TOOLTIPS = {};

KARMA_TOOLTIPS["PUBLICNOTE"] =
	{
		"Эта заметка может быть запрошена другими игроками (если у них есть аддон Karma).",
		"",
		"|cFFFFFF00Сохраняется не более 40 символов|r",
		"Вы можете изменять публичные заметки и рейтинги игроков с помощью различных команд аддона.",
		"По умолчанию: рейтинги никому недоступны, а публичные заметки доступны только согильдийцам."
	};

KARMA_TOOLTIPS["FILTER"] =
	{
		"Он фильтрует список имен.",
		"Фильтры состоят из ключа, дефиса и одного или двух значений.",
		"Возможные фильтры:",
		"|cFFFFFF00n-<Фрагмент>:|r фильтрует по началу имени <Фрагме..>",
		"    (<Фрагме..> вероятно будет начинаться с заглавной буквы..)",
		"|cFFFFFF00p-<фрагмент>:|r фильтрует по фрагменту имени <..рагме..>",
		"    (<..рагме..> может находится в любой части имени)",
		"|cFFFFFF00c-<Класс>:|r только <Класс> (с заглавной 2-3 буквы)",
		"|cFFFFFF00l-<уровень от>-<уровень до>:|r показывает игроков с уровнем из",
		"    заданного диапазона (одно из значений можно опустить)",
		"|cFFFFFF00k-<рейтинг от>-<рейтинг до>:|r показывает игроков с рейтингом",
		"    заданного диапазона (одно из значений можно опустить)",
		"|cFFFFFF00i-<фрагмент>:|r показывает игроков в заметках которых содержится",
		"    <фрагмент> (<фрагмент> может находится в любом месте заметки)",
		"Без ключа строка работает как n-фильтр.",
		"Вы можете объединить все 5 типов фильтров, разделяя их пробелами.",
		"",
		"Пример: |cFFFFFF00n-Ге p-мор c-Жр l--15 k-51-|r",
		"Этот фильтр покажет всех Жрецов (c-Жр) до уровня 15 (l--15)",
		"    с рейтингом 51 и выше (k-51-, второе занчение опущено) и",
		"    чье имя начинается на Ге (n-Ге) и содержит мор (p-мор)."
	};

KARMA_TOOLTIPS["JOINED"] =
	{
		"You can enter a date in various formats:",
		"- like a regular date, year being 4 digits",
		"- as \"nnn days ago\", where nnn is a number",
		"- as \"-nnn\", means the same as \"nnn days ago\""
	};

KARMA_TOOLTIPS["COLORSPACE_ENABLE_CHECKBOX"] =
	{
		"Тонкая настройка цветов",
		"Если этот параметр будет отключен, то цвета",
		"будут сброшены при следующем входе в игру.",
		"Задается два градиента тремя цветами, от",
		"минимума до среднего, и от среднего до максимума"
	};

-- KARMA_ITSELF
-- KARMA_WINEL_FRAG_COLONSPACE
-- KARMA_WINEL_FRAG_TRIDOTS

-- Frame help: requires a KarmaWindow* top level frame
KARMA_FRAMES_HELP = {};

KARMA_FRAMES_HELP.Help_KW_MemberList_Frame =
	{
		"Справка по: " .. KARMA_WINEL_MEMBERLISTTITLE,
		"Тут отображается список всех игроков и гильдий.",
		"~",
		"|cFFFFFF00Назначение клавиш мыши:|r",
		"- |cFFFFFF00Левая|r - выбирает игрока и отображает информацию о нем",
		"- |cFFFFFF00Shift+Левая|r - открывает чат личных сообщений",
		"- |cFFFFFF00Средняя|r - запрашивает обновление данных об игроке",
		"- |cFFFFFF00Правая|r - открывает меню с дополнительными функциями",
		"~",
		"|cFFFFFF00Добавление в группу твинов:|r",
		"- Левая - выбираете основного персонажа",
		"  (информация о персонаже появится справа)",
		"- Правая - нажимаете по твинку, появится меню",
		"- выбираете пункт \"" .. KARMA_WINEL_ALTADDBUTTON .. "<основной персонаж>\""
	};

KARMA_FRAMES_HELP.Help_KW2_List1_Frame =
	{
		"Справка по: " .. KARMA_WINEL_LIST1_TITLE,
		"This shows the list of players currently found online.",
		"~",
		KARMA_ITSELF .. " needs to 'find' the players first, so you'll want",
		"to start with the '" .. KARMA_WINEL_POPULATE_TITLE .. "' button.",
		"~",
		"Then validate your filter options, especially the level range.",
		"(The level range from the '" .. KARMA_WINEL_POPULATE_TITLE .. "' dialog does NOT carry over!)",
		"~",
		"If you've filled the list, clicking on a name selects it into the list",
		"to the right as potential candidate.",
		"~",
		"Players which were seen (by " .. KARMA_ITSELF .. ") in the " .. KARMA_CHANNELNAME_LFG .. " channel",
		"less than 5 mins ago are marked with a green timer, others are yellow."
	};

KARMA_FRAMES_HELP.Help_KW2_PopulateWindow_Frame =
	{
		"Справка по: " .. KARMA_WINEL_POPULATE_TITLE .. "",
		"This dialog helps you fill the list of the players online.",
		"~",
		"Options that are based on '/who' will not work if any other command",
		"in " .. KARMA_ITSELF .. " is still pending.",
		"~",
		"Most likely, you have joined the " .. KARMA_CHANNELNAME_LFG .. " channel.",
		"So, start there to look: Choose the channel via the selection box, then",
		"click on the first checkbox. Then click apply or ok. (Apply leaves the dialog",
		"open, so use it if you know that you want to search in multiple ways.)",
		"This will search in the channel. Those players " .. KARMA_ITSELF .. " knows are immediately",
		"filled with the available information, the other entries are grey",
		"in the left list of the LFG-window.",
		"~",
		"Continue with people you hang out in a channel with in a similar fashion.",
		"~",
		"Finally, you can choose the largest fill choice: Check all classes.",
		"That will take quite some time, but afterwards you have lots of names..."
	};

KARMA_DUNGEON_DIFFICULTY = {
		[1] = "normal",
		[2] = "heroic",
		[3] = "epic"
	};

-- error message for context menu taint
KARMA_TAINT_MENU = "You used a context menu to target/focus someone and it failed with 'Karma has been blocked ...' (a so-called taint error).\n\n"
		.. "Blizzard (mostly) breaks and (seldom) fixes the causing functions, as of 3.1.2 it is currently broken.\n"
		.. "Given the historic pattern of breaking/fixing, a fix isn't to be *expected* any sooner than christmas 2012.\n"
		.. "Until then, the only way to avoid this error is that Karma DOES NOT ADD ENTRIES into any context menus.\n\n"
		.. "If you prefer to use the 'Target'/'Focus' menu items, click 'DISABLE' to disable Karma adding entries.\n"
		.. "(This will also IMMEDIATELY reload the UI to take effect!)\n"
		.. "If you prefer two non-working menu items but added Karma entries, click 'CANCEL'.\n\n"
		.. "You can also change this setting in the options window at the 'Others' section.";

end